/*
 Copyright (c) 2006 - 2007 Eric J. Feminella  <eric@ericfeminella.com>
 All rights reserved.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished
 to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @ignore
 */

package com.ericfeminella.examples
{
	import com.ericfeminella.rpc.AMFPHPRemoteGateway;
	import mx.rpc.IResponder;
	
    /**
     * Provides AMFPHP remote method invocation on remote PHP objects
     */
	public class AMFPHPRemoteGatewayExample extends AMFPHPRemoteGateway implements IResponder
	{
	   [Bindable]
		public var message:String;
		
		/**
		 * Constructor
		 * 
		 * Instantiates an instance of AMFPHPRemoteGateway and initializes 
		 * paramters
		 * 
		 * @param the location of the gateway URI; e.g: http://localhost/amfphp/gateway.php
		 * @param the classpath for the remote PHP class; e.g: com.ericfeminella.AMFPHPRemoteGatewayExample
		 * @param the method to invoke on the remote class; e.g: sendMessage
		 */
		public function AMFPHPRemoteGatewayExample(gateWayURI:String, classPath:String)
		{
			super(gateWayURI);
			this.addResponder(this);
			this.remoteServiceClass(classPath);
			this.disconnect();
		}
        
        /**
         * Handles the result callbacks
         * 
         * @param data object associated with a result
         */
		public function result(data:Object):void
		{
			this.message = data as String;
		}
		
        /**
         * Handles the fault callbacks
         * 
         * @param info object associated with a fault
         */ 
		public function fault(info:Object):void
		{
			this.message = fault as String;
		}
	}
}


